/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.platform;

import icyllis.modernui.ModernUI;
import icyllis.modernui.platform.Clipboard;
import icyllis.modernui.platform.Monitor;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.platform.VideoMode;
import java.nio.IntBuffer;
import javax.annotation.Nonnull;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;

public final class Window
implements AutoCloseable {
    private final long mHandle;
    private int mXPos;
    private int mYPos;
    private int mWidth;
    private int mHeight;
    private int mFramebufferWidth;
    private int mFramebufferHeight;
    private int mWindowedX;
    private int mWindowedY;
    private float mContentScaleX;
    private float mContentScaleY;
    @Nonnull
    private State mState;
    private boolean mMaximized;
    private boolean mBorderless;
    private boolean mFullscreen;
    private boolean mNeedRefresh;

    public Window(@Nonnull String title, @Nonnull State state, int width, int height) {
        long handle;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139272, (int)0);
        GLFW.glfwWindowHintString((int)147457, (CharSequence)title);
        GLFW.glfwWindowHintString((int)147458, (CharSequence)title);
        Monitor monitor = Monitor.getPrimary();
        switch (state) {
            case FULLSCREEN_BORDERLESS: {
                VideoMode m3;
                GLFW.glfwWindowHint((int)131077, (int)0);
                if (monitor != null) {
                    m3 = monitor.getCurrentMode();
                    handle = GLFW.glfwCreateWindow((int)m3.getWidth(), (int)m3.getHeight(), (CharSequence)title, (long)0L, (long)0L);
                } else {
                    handle = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)0L, (long)0L);
                }
                this.mBorderless = true;
                break;
            }
            case FULLSCREEN: {
                VideoMode m3;
                if (monitor != null) {
                    if (width <= 0 || height <= 0) {
                        m3 = monitor.getCurrentMode();
                        handle = GLFW.glfwCreateWindow((int)m3.getWidth(), (int)m3.getHeight(), (CharSequence)title, (long)monitor.getNativePtr(), (long)0L);
                    } else {
                        handle = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor.getNativePtr(), (long)0L);
                    }
                    this.mFullscreen = true;
                    break;
                }
            }
            default: {
                handle = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)0L, (long)0L);
            }
        }
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create window");
        }
        GLFW.glfwSetWindowPosCallback((long)handle, this::callbackPos);
        GLFW.glfwSetWindowSizeCallback((long)handle, this::callbackSize);
        GLFW.glfwSetWindowRefreshCallback((long)handle, this::callbackRefresh);
        GLFW.glfwSetWindowFocusCallback((long)handle, this::callbackFocus);
        GLFW.glfwSetWindowIconifyCallback((long)handle, this::callbackIconify);
        GLFW.glfwSetWindowMaximizeCallback((long)handle, this::callbackMaximize);
        GLFW.glfwSetFramebufferSizeCallback((long)handle, this::callbackFramebufferSize);
        GLFW.glfwSetWindowContentScaleCallback((long)handle, this::callbackContentScale);
        GLFW.glfwSetKeyCallback((long)handle, (window, keycode, scancode, action, mods) -> {
            if (action == 1 && (mods & 2) != 0 && keycode == 86) {
                ModernUI.LOGGER.info("Paste: {}", (Object)Clipboard.getText());
            }
        });
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer w = stack.mallocInt(1);
            IntBuffer h2 = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)handle, (IntBuffer)w, (IntBuffer)h2);
            this.mWidth = w.get(0);
            this.mHeight = h2.get(0);
            w.position(0);
            h2.position(0);
            GLFW.glfwGetFramebufferSize((long)handle, (IntBuffer)w, (IntBuffer)h2);
            this.mFramebufferWidth = w.get(0);
            this.mFramebufferHeight = h2.get(0);
            if (!this.mFullscreen && monitor != null) {
                VideoMode m4 = monitor.getCurrentMode();
                GLFW.glfwSetWindowPos((long)handle, (int)((m4.getWidth() - this.mWidth) / 2 + monitor.getXPos()), (int)((m4.getHeight() - this.mHeight) / 2 + monitor.getYPos()));
            }
        }
        this.mHandle = handle;
        this.mState = state;
        this.mNeedRefresh = true;
    }

    private void callbackPos(long window, int xPos, int yPos) {
        this.mXPos = xPos;
        this.mYPos = yPos;
    }

    private void callbackSize(long window, int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    private void callbackRefresh(long window) {
        if (!this.mNeedRefresh) {
            this.mNeedRefresh = true;
            RenderCore.interruptThread();
        }
    }

    private void callbackFocus(long window, boolean focused) {
    }

    private void callbackIconify(long window, boolean iconified) {
        this.mState = iconified ? State.MINIMIZED : (this.mMaximized ? State.MAXIMIZED : State.WINDOWED);
    }

    private void callbackMaximize(long window, boolean maximized) {
        this.mState = maximized ? State.MAXIMIZED : State.WINDOWED;
        this.mMaximized = maximized;
    }

    private void callbackFramebufferSize(long window, int width, int height) {
        this.mFramebufferWidth = width;
        this.mFramebufferHeight = height;
    }

    private void callbackContentScale(long window, float scaleX, float scaleY) {
    }

    private void applyMode() {
        GLFW.glfwSetWindowMonitor((long)this.mHandle, (long)GLFW.glfwGetPrimaryMonitor(), (int)0, (int)0, (int)1920, (int)1080, (int)144);
    }

    public long getHandle() {
        return this.mHandle;
    }

    public void makeCurrent() {
        GLFW.glfwMakeContextCurrent((long)this.mHandle);
    }

    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.mHandle);
    }

    public boolean exists() {
        return !GLFW.glfwWindowShouldClose((long)this.mHandle);
    }

    public void swapBuffers() {
        GLFW.glfwSwapBuffers((long)this.mHandle);
        this.mNeedRefresh = false;
    }

    public void destroy() {
        Callbacks.glfwFreeCallbacks((long)this.mHandle);
        GLFW.glfwDestroyWindow((long)this.mHandle);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public int getXPos() {
        return this.mXPos;
    }

    public int getYPos() {
        return this.mYPos;
    }

    public int getWidth() {
        return this.mFramebufferWidth;
    }

    public int getHeight() {
        return this.mFramebufferHeight;
    }

    public float getAspectRatio() {
        return (float)this.mFramebufferWidth / (float)this.mFramebufferHeight;
    }

    public boolean needsRefresh() {
        return this.mNeedRefresh;
    }

    public static enum State {
        WINDOWED,
        FULLSCREEN,
        FULLSCREEN_BORDERLESS,
        MAXIMIZED,
        MINIMIZED;

    }
}

